WebInspector.DevicesView=function()
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("devices/devicesView.css");var hbox=this.contentElement.createChild("div","hbox flex-auto");var sidebar=hbox.createChild("div","devices-sidebar");sidebar.createChild("div","devices-view-title").createTextChild(WebInspector.UIString("Devices"));this._sidebarTree=new TreeOutlineInShadow();this._sidebarTree.registerRequiredCSS("devices/sidebar.css");this._sidebarTree.addEventListener(TreeOutline.Events.ElementSelected,this._sidebarTreeElementSelected,this);sidebar.appendChild(this._sidebarTree.element);this._discoveryView=new WebInspector.DevicesView.DiscoveryView();var discoveryTreeTitle=createElementWithClass("div","devices-sidebar-element");discoveryTreeTitle.textContent=WebInspector.UIString("Settings");this._discoveryTreeElement=new TreeElement(discoveryTreeTitle,false);this._sidebarTree.appendChild(this._discoveryTreeElement);this._viewById=new Map();this._devices=[];this._idByTreeElement=new Map();this._treeElementById=new Map();this._viewContainer=hbox.createChild("div","flex-auto");var discoveryFooter=this.contentElement.createChild("div","devices-footer");this._deviceCountSpan=discoveryFooter.createChild("span");discoveryFooter.createChild("span").textContent=WebInspector.UIString(" Read ");discoveryFooter.appendChild(WebInspector.linkifyURLAsNode("https://developers.google.com/chrome-developer-tools/docs/remote-debugging",WebInspector.UIString("remote debugging documentation"),undefined,true));discoveryFooter.createChild("span").textContent=WebInspector.UIString(" for more information.");this._updateFooter();InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.DevicesUpdated,this._devicesUpdated,this);InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);}
WebInspector.DevicesView.prototype={_sidebarTreeElementSelected:function(event)
{var treeElement=(event.data);var view=null;if(treeElement===this._discoveryTreeElement)
view=this._discoveryView;else
view=this._viewById.get((this._idByTreeElement.get(treeElement)));if(this._visibleView===view)
return;if(this._visibleView)
this._visibleView.detach();this._visibleView=view;if(this._visibleView)
this._visibleView.show(this._viewContainer);},_devicesUpdated:function(event)
{this._devices=(event.data).slice();var ids=new Set();for(var device of this._devices)
ids.add(device.id);for(var deviceId of this._viewById.keys()){if(!ids.has(deviceId)){var treeElement=(this._treeElementById.get(deviceId));this._treeElementById.remove(deviceId);this._idByTreeElement.remove(treeElement);this._viewById.remove(deviceId);this._sidebarTree.removeChild(treeElement);}}
for(var device of this._devices){var view=this._viewById.get(device.id);var treeElement=this._treeElementById.get(device.id);if(!view){view=new WebInspector.DevicesView.DeviceView();this._viewById.set(device.id,view);var title=createElementWithClass("div","devices-sidebar-element");title.textContent=device.adbModel;treeElement=new TreeElement(title);this._treeElementById.set(device.id,treeElement);this._idByTreeElement.set(treeElement,device.id);this._sidebarTree.appendChild(treeElement);}
treeElement.title.textContent=device.adbModel;view.update(device);}
this._updateFooter();},_devicesDiscoveryConfigChanged:function(event)
{var discoverUsbDevices=(event.data["discoverUsbDevices"]);var portForwardingEnabled=(event.data["portForwardingEnabled"]);var portForwardingConfig=(event.data["portForwardingConfig"]);this._discoveryView.discoveryConfigChanged(discoverUsbDevices,portForwardingEnabled,portForwardingConfig);},_updateFooter:function()
{this._deviceCountSpan.textContent=!this._devices.length?WebInspector.UIString("No devices detected."):this._devices.length===1?WebInspector.UIString("1 device detected."):WebInspector.UIString("%d devices detected.",this._devices.length);},wasShown:function()
{WebInspector.PanelWithSidebar.prototype.wasShown.call(this);InspectorFrontendHost.setDevicesUpdatesEnabled(true);if(!this._sidebarTree.selectedTreeElement)
this._discoveryTreeElement.select();},willHide:function()
{WebInspector.PanelWithSidebar.prototype.wasShown.call(this);InspectorFrontendHost.setDevicesUpdatesEnabled(false);},__proto__:WebInspector.VBox.prototype}
WebInspector.DevicesView._instance=function()
{if(!WebInspector.DevicesView._instanceObject)
WebInspector.DevicesView._instanceObject=new WebInspector.DevicesView();return WebInspector.DevicesView._instanceObject;}
WebInspector.DevicesView.DiscoveryView=function()
{WebInspector.VBox.call(this);this.setMinimumSize(100,100);this.element.classList.add("discovery-view");this.contentElement.createChild("div","hbox device-text-row").createChild("div","view-title").textContent=WebInspector.UIString("Settings");var discoverUsbDevicesCheckbox=createCheckboxLabel(WebInspector.UIString("Discover USB devices"));discoverUsbDevicesCheckbox.classList.add("usb-checkbox");this.element.appendChild(discoverUsbDevicesCheckbox);this._discoverUsbDevicesCheckbox=discoverUsbDevicesCheckbox.checkboxElement;this._discoverUsbDevicesCheckbox.addEventListener("click",this._updateDiscoveryConfig.bind(this),false);var portForwardingEnabledCheckbox=createCheckboxLabel(WebInspector.UIString("Port forwarding"));portForwardingEnabledCheckbox.classList.add("port-forwarding-checkbox");this.element.appendChild(portForwardingEnabledCheckbox);this._portForwardingEnabledCheckbox=portForwardingEnabledCheckbox.checkboxElement;this._portForwardingEnabledCheckbox.addEventListener("click",this._updateDiscoveryConfig.bind(this),false);this._portForwardingList=this.element.createChild("div","port-forwarding-list");var portForwardingFooter=this.element.createChild("div","port-forwarding-footer");portForwardingFooter.createChild("span").textContent=WebInspector.UIString("Define the listening port on your device that maps to a port accessible from your development machine. ");portForwardingFooter.appendChild(WebInspector.linkifyURLAsNode("https://developer.chrome.com/devtools/docs/remote-debugging#reverse-port-forwarding",WebInspector.UIString("Learn more"),undefined,true));}
WebInspector.DevicesView.DiscoveryView.prototype={discoveryConfigChanged:function(discoverUsbDevices,portForwardingEnabled,portForwardingConfig)
{this._discoverUsbDevicesCheckbox.checked=discoverUsbDevices;this._portForwardingEnabledCheckbox.checked=portForwardingEnabled;},_updateDiscoveryConfig:function()
{InspectorFrontendHost.setDevicesDiscoveryConfig(this._discoverUsbDevicesCheckbox.checked,this._portForwardingEnabledCheckbox.checked,{"8080":"localhost:8080"});},__proto__:WebInspector.VBox.prototype}
WebInspector.DevicesView.DeviceView=function()
{WebInspector.VBox.call(this);this.setMinimumSize(100,100);this.contentElement.classList.add("device-view");var topRow=this.contentElement.createChild("div","hbox device-text-row");this._deviceTitle=topRow.createChild("div","view-title");this._deviceSerial=topRow.createChild("div","device-serial");this._deviceOffline=this.contentElement.createChild("div");this._deviceOffline.textContent=WebInspector.UIString("Pending authentication: please accept debugging session on the device.");this._noBrowsers=this.contentElement.createChild("div");this._noBrowsers.textContent=WebInspector.UIString("No browsers detected.");this._browsers=this.contentElement.createChild("div","device-browser-list vbox");this._browserById=new Map();this._device=null;}
WebInspector.DevicesView.BrowserSection;WebInspector.DevicesView.PageSection;WebInspector.DevicesView.DeviceView.prototype={update:function(device)
{if(!this._device||this._device.adbModel!==device.adbModel)
this._deviceTitle.textContent=device.adbModel;if(!this._device||this._device.adbSerial!==device.adbSerial)
this._deviceSerial.textContent="#"+device.adbSerial;this._deviceOffline.classList.toggle("hidden",device.adbConnected);this._noBrowsers.classList.toggle("hidden",!device.adbConnected||device.browsers.length);this._browsers.classList.toggle("hidden",!device.adbConnected||!device.browsers.length);var browserIds=new Set();for(var browser of device.browsers)
browserIds.add(browser.id);for(var browserId of this._browserById.keys()){if(!browserIds.has(browserId)){this._browserById.get(browserId).element.remove();this._browserById.remove(browserId);}}
for(var browser of device.browsers){var section=this._browserById.get(browser.id);if(!section){section=this._createBrowserSection();this._browserById.set(browser.id,section);this._browsers.appendChild(section.element);}
this._updateBrowserSection(section,browser);}
this._device=device;},_createBrowserSection:function()
{var element=createElementWithClass("div","vbox flex-none");var topRow=element.createChild("div","");var title=topRow.createChild("div","device-browser-title");var pages=element.createChild("div","device-page-list vbox");return{browser:null,element:element,title:title,pages:pages,pageSections:new Map()};},_updateBrowserSection:function(section,browser)
{if(!section.browser||section.browser.adbBrowserName!==browser.adbBrowserName||section.browser.adbBrowserVersion!==browser.adbBrowserVersion){if(browser.adbBrowserVersion)
section.title.textContent=String.sprintf("%s (%s)",browser.adbBrowserName,browser.adbBrowserVersion);else
section.title.textContent=browser.adbBrowserName;}
var pageIds=new Set();for(var page of browser.pages)
pageIds.add(page.id);for(var pageId of section.pageSections.keys()){if(!pageIds.has(pageId)){section.pageSections.get(pageId).element.remove();section.pageSections.remove(pageId);}}
for(var page of browser.pages){var pageSection=section.pageSections.get(page.id);if(!pageSection){pageSection=this._createPageSection();section.pageSections.set(page.id,pageSection);section.pages.appendChild(pageSection.element);}
this._updatePageSection(pageSection,page);}
section.browser=browser;},_createPageSection:function()
{var element=createElementWithClass("div","vbox");var title=element.createChild("div","device-page-title");var url=element.createChild("div","device-page-url");var actions=element.createChild("div","device-page-actions hbox");var section=({page:null,element:element,title:title,url:url});section.inspect=this._createAction(actions,WebInspector.UIString("inspect"),"inspect",section);this._createAction(actions,WebInspector.UIString("reload"),"reload",section);this._createAction(actions,WebInspector.UIString("activate"),"activate",section);this._createAction(actions,WebInspector.UIString("close"),"close",section);return section;},_createAction:function(container,title,action,section)
{var element=container.createChild("div","link");element.textContent=title;element.addEventListener("click",onClick,false);return element;function onClick()
{if(section.page)
InspectorFrontendHost.performActionOnRemotePage(section.page.id,action);}},_updatePageSection:function(section,page)
{if(!section.page||section.page.name!==page.name)
section.title.textContent=page.name;if(!section.page||section.page.url!==page.url){section.url.textContent="";section.url.appendChild(WebInspector.linkifyURLAsNode(page.url,undefined,undefined,true));}
section.inspect.disabled=page.adbAttachedForeign;section.page=page;},__proto__:WebInspector.VBox.prototype};WebInspector.DevicesDialog=function()
{}
WebInspector.DevicesDialog.ActionDelegate=function()
{this._view=null;}
WebInspector.DevicesDialog.ActionDelegate.prototype={handleAction:function(context,actionId)
{if(actionId==="devices.dialog.show"){if(!this._view)
this._view=new WebInspector.DevicesView();var dialog=new WebInspector.Dialog();dialog.addCloseButton();this._view.show(dialog.element);dialog.setMaxSize(new Size(800,600));dialog.show();return true;}
return false;}};Runtime.cachedResources["devices/devicesView.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    padding-top: 15px;\n}\n\n.devices-sidebar {\n    flex: 0 0 120px;\n}\n\n.devices-view-title {\n    font-size: 16px;\n    margin: 0 0 15px 15px;\n    padding-top: 1px;\n}\n\n.view-title {\n    font-size: 16px;\n}\n\n.devices-footer {\n    border-top: 1px solid #cdcdcd;\n    background-color: #f3f3f3;\n    flex: none;\n    padding: 3px 10px;\n}\n\n.devices-footer > span {\n    white-space: pre;\n}\n\n.usb-checkbox {\n    padding-bottom: 8px;\n}\n\n.port-forwarding-checkbox {\n    padding-top: 8px;\n}\n\n.port-forwarding-footer {\n    overflow: hidden;\n    margin: 15px 0 0 25px;\n}\n\n.port-forwarding-footer > * {\n    white-space: pre-wrap;\n}\n\n.device-view {\n    overflow: auto;\n    -webkit-user-select: text;\n}\n\n.device-text-row {\n    align-items: baseline;\n    margin-bottom: 20px;\n}\n\n.device-serial {\n    color: #777;\n    margin-left: 5px;\n}\n\n.device-browser-list {\n    flex: auto;\n    overflow: auto;\n}\n\n.device-browser-list > div {\n    margin-bottom: 15px;\n}\n\n.device-browser-title {\n    font-size: larger;\n}\n\n.device-page-list {\n    margin-top: 10px;\n    overflow-x: auto;\n    align-items: stretch;\n    flex: none;\n}\n\n.device-page-list > div {\n    padding: 5px;\n    overflow: visible;\n    flex: none;\n}\n\n.device-page-list > div:hover {\n    background-color: #f3f3f3;\n}\n\n.device-page-actions {\n    justify-content: flex-start;\n}\n\n.device-page-actions > .link {\n    margin-right: 8px;\n}\n\n.device-page-url {\n    margin: 3px 0;\n}\n\n.device-page-url a {\n    display: block;\n    color: #777;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    overflow: hidden;\n}\n\n/*# sourceURL=devices/devicesView.css */";Runtime.cachedResources["devices/sidebar.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.devices-sidebar-element {\n    color: #222 !important;\n    padding: 6px;\n}\n\nli .selection {\n    background-color: transparent !important;\n    border: none transparent !important;\n    border-left: 6px solid #666 !important;\n}\n/*# sourceURL=devices/sidebar.css */";